{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:11:47 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes,
  WinProcs,
  {$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  MMSystem,
  MMObj,
  MMUtils,
  MMDSPObj,
  MMWavOut,
  MMFXGen,
  MMDesign, MMHook, MMWave;

type
  TFormGenerator = class(TForm)
    Button1: TButton;
    Button2: TButton;
    ScrollBar1: TScrollBar;
    Label1: TLabel;
    FreqLabel: TLabel;
    Label3: TLabel;
    AmpLabel: TLabel;
    ScrollBar2: TScrollBar;
    RadioGroup1: TRadioGroup;
    Generator1: TMMGenerator;
    WaveOut1: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    procedure ScrollBar1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
  public
  end;

var
  FormGenerator: TFormGenerator;

implementation

{$R *.DFM}

(*************************************************************************)
procedure TFormGenerator.FormCreate(Sender: TObject);
begin
   FreqLabel.Caption := IntToStr(ScrollBar1.Position);
   AmpLabel.Caption := VolumeToString(ScrollBar2.Position,VOLUMEBASE,2);
end;

(*************************************************************************)
procedure TFormGenerator.ScrollBar1Change(Sender: TObject);
begin
   FreqLabel.Caption := IntToStr(ScrollBar1.Position);
   Generator1.Frequency := ScrollBar1.Position;
end;

(*************************************************************************)
procedure TFormGenerator.ScrollBar2Change(Sender: TObject);
begin
   AmpLabel.Caption := VolumeToString(ScrollBar2.Position,VOLUMEBASE,2);
   Generator1.Amplitude := ScrollBar2.Position;
end;

(*************************************************************************)
procedure TFormGenerator.RadioGroup1Click(Sender: TObject);
begin
   Generator1.WaveForm := TMMWaveForm(RadioGroup1.ItemIndex);
end;

(*************************************************************************)
procedure TFormGenerator.Button1Click(Sender: TObject);
begin
   WaveOut1.Start;
end;

(*************************************************************************)
procedure TFormGenerator.Button2Click(Sender: TObject);
begin
   WaveOut1.Close;
end;

(*************************************************************************)
procedure TFormGenerator.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut1.Close;
end;

end.
